﻿async function GetFileData(EndTime, Type, secondaryAxis) {
    let mainFileName = $("#DataFrom1").val();
    if (mainFileName == "" || mainFileName == undefined) {
        alert("Main Trendlog ERROR.");
        return false;
    }
    let FileList = new Array(), FileText = new Array();
    let TestsAxisArray = secondaryAxis.split(",");
    let Legend = ["Time", "Y1," + $("#FileData1").val()];
    FileList.push(mainFileName);
    FileText.push($("#FileData1").val());
    for (let i = 2; i < 10; i++) {
        let FileName = $("#DataFrom" + i).val();
        if (TestsAxisArray[i - 2] != "" && FileName != "") {
            FileList.push(FileName);
            FileText.push($("#FileData" + i).val());
            Legend.push(TestsAxisArray[i - 2] + "," + $("#FileData" + i).val());
        }
    }
    for (let f of FileList) {
        var myInit = {
            method: 'GET',
            credentials: 'include'
        };
        if (f != "" && f != undefined) {
            let url = "/api/Files/" + f;
            let res = await fetch(url, myInit).then((response) => response.blob())
                .then((blob) => {
                    let reader = new FileReader();
                    let dataObject = new Array();
                    reader.onload = function (el) {
                        let CSV = reader.result.replaceAll("\r","").split("\n");
                        for (let Row of CSV) {                            
                            let TrendlogData = Row.split(",");
                            if (TrendlogData[1] != undefined) {
                                if (isNaN(TrendlogData[0]) && !isNaN(Date.parse(TrendlogData[0]))) {
                                    let Data = { "time": TrendlogData[0], "value": TrendlogData[1] };
                                    dataObject.push(Data);
                                }
                            }
                            for (let Col of Row.split(",")) {
                                //console.log(Col);                                
                            }
                        }
                        sessionStorage.setItem('t_file_' + f, JSON.stringify(dataObject));
                    }
                    reader.readAsText(blob);
                    /*
                    var url = window.URL.createObjectURL(blob); // create url from blob
                    var fileLink = document.createElement('a'); // create link for file
                    fileLink.href = url;
                    fileLink.download = 'output.csv'; // download filename
                    document.body.appendChild(fileLink); // append file link to download
                    fileLink.click();
                    fileLink.remove(); // remove file link after click
                    */                    
                    return true;
                })
                .catch(function (err) {
                    console.log(err);
                    alert("Files Error.");
                    return false;
                });
            await sleep(800);
        }
    }
    let scope = CollatingData(EndTime, Type);
    let source = PlanningChart(scope, FileList, FileText);
    let Output = { Legend, source };
    return Output;
}
function CollatingData(Time, Type) {
    //Type = 500;
    //Time = "2023-03-29 13:13:13";
    let StartTime = new Date(), EndTime = new Date();
    let Translating = 0;
    if (Time.indexOf("~") > 1) {
        let SetTime = Time.split("~");
        StartTime = new Date(SetTime[0]);
        EndTime = new Date(SetTime[1]);
    } else {
        EndTime = new Date(Time);
        StartTime = new Date(Time);
        switch (Type) {
            case "Days":
            case "Day":
                StartTime.setTime(EndTime - 24 * 60 * 1000 * 60);
                break;
            case "Months":
            case "Month":
                StartTime.setTime(EndTime - 30 * 24 * 60 * 1000 * 60);
                break;
            case "Hours":
            case "Hour":
                StartTime.setTime(EndTime - 60 * 1000 * 60);
                break;
            case "Week":
                StartTime.setTime(EndTime - 7 * 24 * 60 * 1000 * 60);
                break;
            default:
                if (isNumeric(Type)) {                    
                    Translating = Type;
                }
        }
    }    
    return { "startTime": StartTime, "endTime": EndTime, "translating": Translating };
}
function PlanningChart(Scope, Files, FileName) {    
    let TrendlogData = [], TimeList = [];
    let it = 0;
    for (let TData of Files) {
        if (typeof (Storage) !== 'undefined' && sessionStorage['t_file_' + TData]) {
            let trendlog = JSON.parse(sessionStorage["t_file_" + TData]);
            let SelectRange = [];
            let ItemNumber = 0;
            for (let oneData of trendlog) {
                let dt = new Date(oneData.time);
                //console.log(dt.getTime());
                if (Scope.translating > 0) {
                    if (it === 0) {
                        if (dt.getTime() < Scope.endTime.getTime() && ItemNumber <= Scope.translating) {
                            SelectRange.push(oneData);
                            TimeList.push(dt);
                            ItemNumber++;
                        }
                    } else {
                        SelectRange.push(oneData);
                    }
                } else {
                    if (Scope.startTime.getTime() < dt.getTime() && dt.getTime() < Scope.endTime.getTime()) {
                        SelectRange.push(oneData);
                        if (it === 0)
                            TimeList.push(dt);
                    }
                }
            }
            //console.log(SelectRange);
            TrendlogData[it] = SelectRange;
            it++;
        }
    }
    TimeList.sort(function (a, b) {
        return a - b;
    });    
    let Legend = [];
    Legend.push("Time");
    for (let Leg of FileName) {
        if (Leg != undefined && Leg != "")
            Legend.push(Leg);
    }
    let newTrendglogData = [];
    for (let tList of TimeList) {
        for (let i = 0; i < TrendlogData.length; i++) {
            let Value = null;
            for (let j = 0; j < TrendlogData[i].length; j++) {
                let dt = new Date(TrendlogData[i][j].time);
                if (tList.getTime() == dt.getTime()) {                    
                    Value = TrendlogData[i][j].value;
                    if (!newTrendglogData.hasOwnProperty(tList)) {
                        newTrendglogData[tList] = [tList];
                    }
                } else {

                }
            }
            if (newTrendglogData.hasOwnProperty(tList)) {
                newTrendglogData[tList].push(Value);
            } else {
                //newTrendglogData[tList] = [tList, Value];
            }
        }
    }
    
    let source = [Legend];
    for (let tList of TimeList) {
        let day = newTrendglogData[tList][0].getDate();
        let month = newTrendglogData[tList][0].getMonth() + 1;
        let year = newTrendglogData[tList][0].getFullYear();
        let hour = newTrendglogData[tList][0].getHours();
        let minute = newTrendglogData[tList][0].getMinutes();
        let second = newTrendglogData[tList][0].getSeconds();
        if (day < 10) {
            day = '0' + day;
        }
        if (month < 10) {
            month = `0${month}`;
        }
        if (hour < 10) {
            hour = `0${hour}`;
        }
        if (minute < 10) {
            minute = `0${minute}`;
        }
        if (second < 10) {
            second = `0${second}`;
        }
        let Item = newTrendglogData[tList];
        //Item[0] = Item[0].toISOString();
        Item[0] = `${year}-${month}-${day} ${hour}:${minute}:${second}`;
        source.push(Item);
    }
    //console.log(source);
    return source;
}
function isNumeric(n) {
    return !isNaN(parseFloat(n)) && isFinite(n);
}
function sleep(delay) {
    return new Promise((res) => {
        setTimeout(() => res(), delay)
    });
}
function SelectDataSource(Type) {
    let UsedID = document.getElementById("FileUseId").value;
    document.getElementsByName("csvF")[1].value = "";
    if (Type == "trendlog") {
        //document.getElementById("SelectTrendlogList").style.display = "";
        document.getElementById("SelectFile").style.display = "none";
        document.getElementById("SelectServerFile").style.display = "none";
        document.getElementById("DataFrom" + UsedID).value = "";
    } else if (Type == "csv") {
        //document.getElementById("SelectTrendlogList").style.display = "none";
        document.getElementById("SelectFile").style.display = "";
        document.getElementById("SelectServerFile").style.display = "none";
        document.getElementById("DataFrom" + UsedID).value = "";
    } else if (Type == "serverFile") {
        //document.getElementById("SelectTrendlogList").style.display = "none";
        document.getElementById("SelectFile").style.display = "none";
        document.getElementById("SelectServerFile").style.display = "";
    }
}
async function UpdateTrendlogData(id, filename) {
    if (typeof (Storage) !== 'undefined' && sessionStorage['t_file_' + filename]) {
        var trendlogData = JSON.parse(sessionStorage["t_file_" + filename]);
        var keyMap = { //修改Key
            "time": "Date_Time",
            "value": "Value"
        };

        for (var i = 0; i < trendlogData.length; i++) {
            var obj = trendlogData[i];
            for (var key in obj) {
                var newKey = keyMap[key];
                if (newKey) {
                    obj[newKey] = obj[key];
                    delete obj[key];
                }
            }
        }
    } else {
        alert("Data error.");
        return false;
    }
    const uri = "/api/Trendlog/" + id;
    let token = $("input[name='__RequestVerificationToken']").val();
    const item = {
        type: "updateTrendlogData",
        UserName: $("#UserName").val(),
        mainTrendlog: filename,
        secondaryTrendlog: "",
        secondaryAxis: "",
        TimeRange: JSON.stringify(trendlogData),
        ID: id
    };
    let res = await fetch(uri, {
        method: 'PUT',
        body: JSON.stringify(item),
        headers: new Headers({
            'Content-Type': 'application/json',
            "RequestVerificationToken": token
        })
    }).catch(error => console.error('Error:', error));
    if (200 <= res.status && res.status <= 299) {
        let response = await res.json();
        //console.log(response);
        if (response.status == "true") {
            alert("Complete");
        } else {
            alert(response.message);
        }
    } else {
        alert(res.status + ":" + res.statusText);
    }
}