﻿function keypadLayout(keypad) {
    this.qwerty = ['~|!|@|#|$|%|^|&|*|+|-|,|:' ,
        '1|2|3|4|5|6|7|8|9|0|.|' + keypad.CLEAR,
        'a|b|c|d|e|f|g|h|i|j|k|' + keypad.BACK,
        'l|m|n|o|p|q|r|s|t|u|v|' + keypad.SHIFT,
        'w|x|y|z|' + keypad.SPACE_BAR + "|" + keypad.SPACE + "|" + keypad.ENTER ];

    this.Number = ['7|8|9|' + keypad.CLOSE,
        '4|5|6|' + keypad.CLEAR,
        '1|2|3|' + keypad.BACK,
        '.|0|-'];
    this.FullKeyBoard = keypad.qwertyLayout;
}

function GetKeypad(id, type = "num",title = "" ,showAnim ="blind") {
    document.getElementById(id).blur();
    let objDisabled = false;    
    if (document.getElementById(id).disabled != null && document.getElementById(id).disabled) {
        document.getElementById(id).disabled = false;
        objDisabled = true;
    }
    var keypadL = new keypadLayout($.keypad);
    if (type == "num") {
        $("#" + id).attr("type", "text");
        $('#' + id).keypad({
            keypadOnly: false, separator: '|', prompt: title, showAnim: showAnim,
            layout: keypadL.Number
        });
    } else if (type == "text") {
        $('#' + id).keypad({
            keypadOnly: false, separator: '|', prompt: title, showAnim: showAnim,
            layout: keypadL.qwerty
        });
    } else if (type == "textarea") {
        $('#' + id).keypad({
            keypadOnly: false, prompt: title, showAnim: showAnim,
            layout: keypadL.FullKeyBoard
        });
    }
    if (objDisabled)
        document.getElementById(id).disabled = true;
}